#include <iostream>

#include "TFile.h"
#include "TMath.h"
#include "TH1.h"
#include "TH2.h"
#include "TStyle.h"
#include "TCanvas.h"
#include "TPad.h"
#include "TF1.h"
#include "TF2.h"
#include "TStyle.h"
#include "TPad.h"
#include "TLine.h"
#include "TPaveText.h"
#include "TLegend.h"
#include "TVirtualFitter.h"
#include "TGraph.h"
#include "TMinuit.h"
#include "TColor.h"
#include "TString.h"
#include "TH3D.h"
#include "THnSparse.h"

Double_t ptebins[] = {0,0.1,0.2,0.22,0.24,0.26,0.28,0.3,0.32,0.34,0.36,0.38,0.4,0.42,0.44,0.46,0.48,0.5,0.52,0.54,0.56,0.58,0.6,0.62,0.64,0.66,0.68,0.7,0.72,0.74,0.76,0.78,0.8,0.82,0.84,0.86,0.88,0.9,0.92,0.94,0.96,0.98,1.,1.2,1.4,1.6,1.8,2.,2.2,2.4,2.6,2.8,3.,3.2,3.4,3.6,3.8,4.,4.5,5.,5.5,6.,6.5,7.,7.5,8.,8.5,9.,10.,15,20};
Int_t nbinspte  = sizeof(ptebins)/sizeof(*ptebins) -1;

TString source = "lf_prompt;c2l;b2l;b2c2l";
Int_t colorsource[4] = {1,2,4,6};
Int_t stylesource[4] = {21,22,23,24};
const Int_t nbsource = 4;

void PlotSingleEfficiency(TString namefile="../MC/AnalysisResults.root")
{

  //
  // Comparison
  //

  gStyle->SetPalette(1);
  gStyle->SetOptStat(1111);
  gStyle->SetPadBorderMode(0);
  gStyle->SetCanvasColor(10);
  gStyle->SetPadLeftMargin(0.13);
  gStyle->SetPadRightMargin(0.13);
  gStyle->SetPadBottomMargin(0.13);
  gStyle->SetPadTopMargin(0.13);

  Double_t minpt = 0.4;
  Double_t maxpt = 0.5;


  TObjArray *arrSourceNames=source.Tokenize(";");
  //printf("Number of source names %d\n",arrSourceNames->GetEntriesFast());
  //Int_t nbsource = arrSourceNames->GetEntriesFast();


  //
  //

  printf("Take file DATA\n");

  TFile *fdata = TFile::Open(namefile.Data());
  TDirectoryFile *dir = (TDirectoryFile *) fdata->Get("single-electron-qc-mc_Trk_DCA_ITSFirst");

  // Generated
  TH1D*Gen[nbsource];
  TH1D*GenEta[nbsource];
  TH1D*GenPhi[nbsource];
  TDirectoryFile *dirMC = (TDirectoryFile *) dir->Get("Generated");
  // loop over sources
  for(Int_t k=0; k < nbsource; k++) {
    TDirectoryFile *dirsource = (TDirectoryFile *) dirMC->Get(arrSourceNames->At(k)->GetName());
    THnSparseD *hs = (THnSparseD *) dirsource->Get("hs");
    // axis 0: pt; 1: eta; 2: phi; 3: charge
    hs->GetAxis(1)->SetRangeUser(-0.8,0.8);
    Gen[k] = (TH1D *) (hs->Projection(0))->Rebin(nbinspte,"electron_pt_ce_gen",&ptebins[0]);
    Gen[k]->SetName(Form("Generator_pt_%s",arrSourceNames->At(k)->GetName()));
    Gen[k]->SetDirectory(0);
    Gen[k]->SetStats(0);
    Gen[k]->SetLineColor(colorsource[k]);
    Gen[k]->SetMarkerColor(colorsource[k]);
    Gen[k]->SetMarkerStyle(stylesource[k]);
    Gen[k]->SetTitle("");

    hs->GetAxis(1)->SetRangeUser(-1.2,1.2);
    hs->GetAxis(0)->SetRangeUser(minpt,maxpt);
    //GenPhi[k] = (TH1D *) (hs->Projection(2))->Rebin(nbinspte,"electron_pt_ce_gen",&ptebins[0]);
    GenPhi[k] = (TH1D *) (hs->Projection(2));
    GenPhi[k]->SetName(Form("Generator_phi_%s",arrSourceNames->At(k)->GetName()));
    GenPhi[k]->SetDirectory(0);
    GenPhi[k]->SetStats(0);
    GenPhi[k]->SetLineColor(colorsource[k]);
    GenPhi[k]->SetMarkerColor(colorsource[k]);
    GenPhi[k]->SetMarkerStyle(stylesource[k]);
    GenPhi[k]->SetTitle("");

    hs->GetAxis(1)->SetRangeUser(-0.8,0.8);
    //GenEta[k] = (TH1D *) (hs->Projection(2))->Rebin(nbinspte,"electron_pt_ce_gen",&ptebins[0]);
    GenEta[k] = (TH1D *) (hs->Projection(1));
    GenEta[k]->SetName(Form("Generator_eta_%s",arrSourceNames->At(k)->GetName()));
    GenEta[k]->SetDirectory(0);
    GenEta[k]->SetStats(0);
    GenEta[k]->SetLineColor(colorsource[k]);
    GenEta[k]->SetMarkerColor(colorsource[k]);
    GenEta[k]->SetMarkerStyle(stylesource[k]);
    GenEta[k]->SetTitle("");
  }


  // Reconstructed
  TH1D*Rec[nbsource];
  TH1D*RecEta[nbsource];
  TH1D*RecPhi[nbsource];
  TDirectoryFile *dirRec = (TDirectoryFile *) dir->Get("Track");
  // loop over sources
  for(Int_t k=0; k < nbsource; k++) {
    TDirectoryFile *dirsource = (TDirectoryFile *) dirRec->Get(arrSourceNames->At(k)->GetName());

    TDirectoryFile *dirsourcepos = (TDirectoryFile *) dirsource->Get("positive");
    THnSparseD *hspos = (THnSparseD *) dirsourcepos->Get("hs");

    // axis 0: pt; 1: eta; 2: phi; 3: DCA3(sigma), 4: DCAxy(sigma), 5: DCAz(sigma), 6: charge
    hspos->GetAxis(1)->SetRangeUser(-0.8,0.8);
    Rec[k] =  (TH1D *) (hspos->Projection(0))->Rebin(nbinspte,"electron_pt_ce_gen",&ptebins[0]);
    Rec[k]->SetName(Form("Rec_pt_%s",arrSourceNames->At(k)->GetName()));
    Rec[k]->SetDirectory(0);
    Rec[k]->SetStats(0);
    Rec[k]->SetLineColor(colorsource[k]);
    Rec[k]->SetMarkerColor(colorsource[k]);
    Rec[k]->SetMarkerStyle(stylesource[k]);
    Rec[k]->GetXaxis()->SetTitle("#it{p}_{T,e} (GeV/#it{c})");
    Rec[k]->GetYaxis()->SetTitle("Eff");
    Rec[k]->GetYaxis()->SetTitleSize(0.045);
    Rec[k]->GetXaxis()->SetTitleSize(0.045);
    Rec[k]->SetTitle("");

    hspos->GetAxis(1)->SetRangeUser(-1.2,1.2);
    hspos->GetAxis(0)->SetRangeUser(minpt,maxpt);
    //RecPhi[k] =  (TH1D *) (hspos->Projection(0))->Rebin(nbinspte,"electron_pt_ce_gen",&ptebins[0]);
    RecPhi[k] =  (TH1D *) (hspos->Projection(2));
    RecPhi[k]->SetName(Form("Rec_pt_%s",arrSourceNames->At(k)->GetName()));
    RecPhi[k]->SetDirectory(0);
    RecPhi[k]->SetStats(0);
    RecPhi[k]->SetLineColor(colorsource[k]);
    RecPhi[k]->SetMarkerColor(colorsource[k]);
    RecPhi[k]->SetMarkerStyle(stylesource[k]);
    RecPhi[k]->GetXaxis()->SetTitle("#it{#varphi} (rad)");
    RecPhi[k]->GetYaxis()->SetTitle("Eff");
    RecPhi[k]->GetYaxis()->SetTitleSize(0.045);
    RecPhi[k]->GetXaxis()->SetTitleSize(0.045);
    RecPhi[k]->SetTitle("");

    hspos->GetAxis(1)->SetRangeUser(-0.8,0.8);
    //RecEta[k] =  (TH1D *) (hspos->Projection(0))->Rebin(nbinspte,"electron_pt_ce_gen",&ptebins[0]);
    RecEta[k] =  (TH1D *) (hspos->Projection(1));
    RecEta[k]->SetName(Form("Rec_pt_%s",arrSourceNames->At(k)->GetName()));
    RecEta[k]->SetDirectory(0);
    RecEta[k]->SetStats(0);
    RecEta[k]->SetLineColor(colorsource[k]);
    RecEta[k]->SetMarkerColor(colorsource[k]);
    RecEta[k]->SetMarkerStyle(stylesource[k]);
    RecEta[k]->GetXaxis()->SetTitle("#it{#eta}");
    RecEta[k]->GetYaxis()->SetTitle("Eff");
    RecEta[k]->GetYaxis()->SetTitleSize(0.045);
    RecEta[k]->GetXaxis()->SetTitleSize(0.045);
    RecEta[k]->SetTitle("");


    TDirectoryFile *dirsourceneg = (TDirectoryFile *) dirsource->Get("negative");
    THnSparseD *hsneg = (THnSparseD *) dirsourceneg->Get("hs");

    // axis 0: pt; 1: eta; 2: phi; 3: DCA3(sigma), 4: DCAxy(sigma), 5: DCAz(sigma), 6: charge
    hsneg->GetAxis(1)->SetRangeUser(-0.8,0.8);
    TH1D *hf =  (TH1D *) (hsneg->Projection(0))->Rebin(nbinspte,"electron_pt_ce_gen",&ptebins[0]);
    Rec[k]->Add(hf);

    hsneg->GetAxis(1)->SetRangeUser(-1.2,1.2);
    hsneg->GetAxis(0)->SetRangeUser(minpt,maxpt);
    //TH1D *hff =  (TH1D *) (hsneg->Projection(2))->Rebin(nbinspte,"electron_phi_ce_gen",&ptebins[0]);
    TH1D *hff =  (TH1D *) (hsneg->Projection(2));
    RecPhi[k]->Add(hff);

    hsneg->GetAxis(1)->SetRangeUser(-0.8,0.8);
    //TH1D *hff =  (TH1D *) (hsneg->Projection(2))->Rebin(nbinspte,"electron_phi_ce_gen",&ptebins[0]);
    TH1D *hfff =  (TH1D *) (hsneg->Projection(1));
    RecEta[k]->Add(hfff);

    // Efficiency
    Rec[k]->Divide(Gen[k]);
    RecPhi[k]->Divide(GenPhi[k]);
    RecEta[k]->Divide(GenEta[k]);

  }


   //
  // Plot
  //

  Int_t canvWidth  = 650;	// 670x700 ok to get vertical pdf when importing to ppt.
  //Int_t canvHeight = 1000;
  Int_t canvHeight = 800;
  Int_t canvXshift = 50;

  double fRatioPadSize = 0.3;

  TCanvas *csinglepteff = new TCanvas("csinglepteff","csinglepteff",canvXshift, 0, canvWidth, canvHeight);
  csinglepteff->Divide(1,2);
  //double fRatioPadSize = 0.3;
  //Double_t bottommargin = 0.1/fRatioPadSize;//Platz zu Boden
  csinglepteff->SetMargin(0.13, 0.05, 0.1, 0.05);
  csinglepteff->cd(1)->SetPad(0., fRatioPadSize, 1., 1.);  // ins obere pad x1,y1,x2,y2
  csinglepteff->cd(1)->SetBottomMargin(0.0);//oberes pad wie viel platz nach unten frei gelassen wird
  csinglepteff->cd(2)->SetPad(0., 0., 1., fRatioPadSize);  // bottom pad
  csinglepteff->cd(2)->SetTopMargin(0);
  csinglepteff->cd(2)->SetBottomMargin(0.3);
  csinglepteff->cd(1);
  gPad->SetTicks();
  gPad->SetGrid();
  //gPad->SetLogy();
  gPad->SetLogx();
  for(Int_t k=0; k < nbsource; k++) {
    Rec[k]->GetYaxis()->SetRangeUser(0.,1.2);
    if(k==0) Rec[k]->Draw("");
    else Rec[k]->Draw("Same");
  }
  TLegend *legqutacc = new TLegend(0.132832,0.7551,0.547619,0.898964); //
  legqutacc->SetBorderSize(0);
  legqutacc->SetFillStyle(0);
  legqutacc->SetTextFont(43);
  legqutacc->SetTextSize(26);
  legqutacc->SetLineColorAlpha(0,0);
  for(Int_t k=0; k < nbsource; k++) {
    legqutacc->AddEntry(Rec[k], arrSourceNames->At(k)->GetName(), "p");
  }
  legqutacc->Draw("same");

  csinglepteff->cd(2);
  gPad->SetTicks();
  gPad->SetLogx();
  TH1D *ratioo[nbsource];
  for(Int_t k = 1; k < nbsource; k++) {
    ratioo[k] = (TH1D *) Rec[k]->Clone(Form("Ratio_%s",arrSourceNames->At(k)->GetName()));
    ratioo[k]->Divide(Rec[0]);
    ratioo[k]->SetTitle("");
    ratioo[k]->GetYaxis()->SetTitle("Ratio to second");
    ratioo[k]->GetYaxis()->SetRangeUser(0.,2.1);
    ratioo[k]->GetYaxis()->SetLabelSize(0.08);
    ratioo[k]->GetYaxis()->SetTitleSize(0.1);
    ratioo[k]->GetYaxis()->SetTitleOffset(0.6);
    ratioo[k]->GetXaxis()->SetTitleSize(0.1);
    ratioo[k]->GetXaxis()->SetTitleOffset(1.3);
    ratioo[k]->GetXaxis()->SetLabelSize(0.07);
    if(k==1) ratioo[k]->Draw();
    else ratioo[k]->Draw("same");
  }
  TLine *lineeee = new TLine(0.,1.0,20,1.0);
  lineeee->SetLineStyle(2);
  lineeee->SetLineWidth(2);
  lineeee->SetLineColor(1);
  lineeee->Draw("same");



  TCanvas *csinglephieff = new TCanvas("csinglephieff","csinglephieff",canvXshift, 0, canvWidth, canvHeight);
  csinglephieff->Divide(1,2);
  //double fRatioPadSize = 0.3;
  //Double_t bottommargin = 0.1/fRatioPadSize;//Platz zu Boden
  csinglephieff->SetMargin(0.13, 0.05, 0.1, 0.05);
  csinglephieff->cd(1)->SetPad(0., fRatioPadSize, 1., 1.);  // ins obere pad x1,y1,x2,y2
  csinglephieff->cd(1)->SetBottomMargin(0.0);//oberes pad wie viel platz nach unten frei gelassen wird
  csinglephieff->cd(2)->SetPad(0., 0., 1., fRatioPadSize);  // bottom pad
  csinglephieff->cd(2)->SetTopMargin(0);
  csinglephieff->cd(2)->SetBottomMargin(0.3);
  csinglephieff->cd(1);
  gPad->SetTicks();
  gPad->SetGrid();
  //gPad->SetLogy();
  //gPad->SetLogx();
  for(Int_t k=0; k < nbsource; k++) {
    RecPhi[k]->GetYaxis()->SetRangeUser(0.,1.2);
    if(k==0) RecPhi[k]->Draw("");
    else RecPhi[k]->Draw("Same");
  }
  TLegend *legqutaccphi = new TLegend(0.132832,0.7551,0.547619,0.898964); //
  legqutaccphi->SetBorderSize(0);
  legqutaccphi->SetFillStyle(0);
  legqutaccphi->SetTextFont(43);
  legqutaccphi->SetTextSize(26);
  legqutaccphi->SetLineColorAlpha(0,0);
  for(Int_t k=0; k < nbsource; k++) {
    legqutaccphi->AddEntry(RecPhi[k], arrSourceNames->At(k)->GetName(), "p");
  }
  legqutaccphi->Draw("same");

  csinglephieff->cd(2);
  gPad->SetTicks();
  //gPad->SetLogx();
  TH1D *ratioophi[nbsource];
  for(Int_t k = 1; k < nbsource; k++) {
    ratioophi[k] = (TH1D *) RecPhi[k]->Clone(Form("Ratio_phi_%s",arrSourceNames->At(k)->GetName()));
    ratioophi[k]->Divide(RecPhi[0]);
    ratioophi[k]->SetTitle("");
    ratioophi[k]->GetYaxis()->SetTitle("Ratio to second");
    ratioophi[k]->GetYaxis()->SetRangeUser(0.,2.1);
    ratioophi[k]->GetYaxis()->SetLabelSize(0.08);
    ratioophi[k]->GetYaxis()->SetTitleSize(0.1);
    ratioophi[k]->GetYaxis()->SetTitleOffset(0.6);
    ratioophi[k]->GetXaxis()->SetTitleSize(0.1);
    ratioophi[k]->GetXaxis()->SetTitleOffset(1.3);
    ratioophi[k]->GetXaxis()->SetLabelSize(0.07);
    if(k==1) ratioophi[k]->Draw();
    else ratioophi[k]->Draw("same");
  }
  TLine *lineeeephi = new TLine(0.,1.0,TMath::Pi()*2.,1.0);
  lineeeephi->SetLineStyle(2);
  lineeeephi->SetLineWidth(2);
  lineeeephi->SetLineColor(1);
  lineeeephi->Draw("same");


  TCanvas *csingleetaeff = new TCanvas("csingleetaeff","csingleetaeff",canvXshift, 0, canvWidth, canvHeight);
  csingleetaeff->Divide(1,2);
  //double fRatioPadSize = 0.3;
  //Double_t bottommargin = 0.1/fRatioPadSize;//Platz zu Boden
  csingleetaeff->SetMargin(0.13, 0.05, 0.1, 0.05);
  csingleetaeff->cd(1)->SetPad(0., fRatioPadSize, 1., 1.);  // ins obere pad x1,y1,x2,y2
  csingleetaeff->cd(1)->SetBottomMargin(0.0);//oberes pad wie viel platz nach unten frei gelassen wird
  csingleetaeff->cd(2)->SetPad(0., 0., 1., fRatioPadSize);  // bottom pad
  csingleetaeff->cd(2)->SetTopMargin(0);
  csingleetaeff->cd(2)->SetBottomMargin(0.3);
  csingleetaeff->cd(1);
  gPad->SetTicks();
  gPad->SetGrid();
  //gPad->SetLogy();
  //gPad->SetLogx();
  for(Int_t k=0; k < nbsource; k++) {
    RecEta[k]->GetYaxis()->SetRangeUser(0.,1.2);
    if(k==0) RecEta[k]->Draw("");
    else RecEta[k]->Draw("Same");
  }
  TLegend *legqutacceta = new TLegend(0.132832,0.7551,0.547619,0.898964); //
  legqutacceta->SetBorderSize(0);
  legqutacceta->SetFillStyle(0);
  legqutacceta->SetTextFont(43);
  legqutacceta->SetTextSize(26);
  legqutacceta->SetLineColorAlpha(0,0);
  for(Int_t k=0; k < nbsource; k++) {
    legqutacceta->AddEntry(RecEta[k], arrSourceNames->At(k)->GetName(), "p");
  }
  legqutacceta->Draw("same");

  csingleetaeff->cd(2);
  gPad->SetTicks();
  //gPad->SetLogx();
  TH1D *ratiooeta[nbsource];
  for(Int_t k = 1; k < nbsource; k++) {
    ratiooeta[k] = (TH1D *) RecEta[k]->Clone(Form("Ratio_eta_%s",arrSourceNames->At(k)->GetName()));
    ratiooeta[k]->Divide(RecEta[0]);
    ratiooeta[k]->SetTitle("");
    ratiooeta[k]->GetYaxis()->SetTitle("Ratio to second");
    ratiooeta[k]->GetYaxis()->SetRangeUser(0.,2.1);
    ratiooeta[k]->GetYaxis()->SetLabelSize(0.08);
    ratiooeta[k]->GetYaxis()->SetTitleSize(0.1);
    ratiooeta[k]->GetYaxis()->SetTitleOffset(0.6);
    ratiooeta[k]->GetXaxis()->SetTitleSize(0.1);
    ratiooeta[k]->GetXaxis()->SetTitleOffset(1.3);
    ratiooeta[k]->GetXaxis()->SetLabelSize(0.07);
    if(k==1) ratiooeta[k]->Draw();
    else ratiooeta[k]->Draw("same");
  }
  TLine *lineeeeeta = new TLine(-0.8,1.0,0.8,1.0);
  lineeeeeta->SetLineStyle(2);
  lineeeeeta->SetLineWidth(2);
  lineeeeeta->SetLineColor(1);
  lineeeeeta->Draw("same");



}
