int GetSerialColors(int colorbins = 1){
    const int NRGBs = 5;
    double stops[NRGBs] = {0.00, 0.34, 0.61, 0.84, 1.00};
    double red[NRGBs] = {0.00, 0.00, 0.87, 0.9 * 1.00, 0.51};
    double green[NRGBs] = {0.00, 0.81, 0.9 * 1.00, 0.20, 0.00};
    double blue[NRGBs] = {0.51, 0.9 * 1.00, 0.12, 0.00, 0.00};
    int FIf = TColor::CreateGradientColorTable(NRGBs, stops, red, green, blue,
                                                 colorbins);
    return FIf;
}

void ana_sp(){
 TFile* fin = new TFile("AnalysisResults.root", "read");

 TH2F* hEpResQvecDetRefAxx = (TH2F*)fin->Get("q-vectorstutorial/EpResQvecDetRefAxx");
 TH2F* hEpResQvecDetRefBxx = (TH2F*)fin->Get("q-vectorstutorial/EpResQvecDetRefBxx");
 TH2F* hEpResQvecRefARefBxx = (TH2F*)fin->Get("q-vectorstutorial/EpResQvecRefARefBxx");

// TH3F* hvncos = (TH3F*)fin->Get("q-vectorstutorial/histCorCosDetV2");
 TH3F* hvncos = (TH3F*)fin->Get("q-vectorstutorial/SPvnxx");

 TProfile* profEpResQvecDetRefAxx = (TProfile*)hEpResQvecDetRefAxx->ProfileX();
 TProfile* profEpResQvecDetRefBxx = (TProfile*)hEpResQvecDetRefAxx->ProfileX();
 TProfile* profEpResQvecRefARefBxx = (TProfile*)hEpResQvecDetRefAxx->ProfileX();

 TGraphErrors* gRes = new TGraphErrors();

 for(int i=0;i<profEpResQvecDetRefAxx->GetNbinsX();i++){
	gRes->SetPoint(i, profEpResQvecDetRefAxx->GetBinCenter(i+1), sqrt( profEpResQvecDetRefAxx->GetBinContent(i+1) * profEpResQvecDetRefBxx->GetBinContent(i+1) / profEpResQvecRefARefBxx->GetBinContent(i+1)));
 }

 const int npt = 9;
 const int ncent = 1;
 double pt[npt+1] = {
    0.2, 0.5, 1.0, 1.5, 2.0,
	3.0, 4.0, 5.0, 7.0, 10.0};
 double cent[ncent+1] = {
	20, 40};

 TH1D* hvn[ncent][npt];

 double vn[ncent][npt];
 double vnstat[ncent][npt];

 TGraphErrors* gpt[ncent];

 int RainbowColor[ncent];
 int sysColorPallet = GetSerialColors(ncent);
 for(int i=0;i<ncent;i++){
    RainbowColor[i] = sysColorPallet + ncent - i -1;
 }

 for(int i=0;i<ncent;i++){
    gpt[i] = new TGraphErrors();
    gpt[i]->SetLineColor(RainbowColor[i]);
    gpt[i]->SetMarkerColor(RainbowColor[i]);

    for(int j=0;j<npt;j++){
        hvn[i][j] = (TH1D*)hvncos->ProjectionZ(Form("proj_%d_%d",i,j),
			hvncos->GetXaxis()->FindBin(cent[i]), hvncos->GetXaxis()->FindBin(cent[i+1]-0.0001),
			hvncos->GetYaxis()->FindBin(pt[j]), hvncos->GetYaxis()->FindBin(pt[j+1]-0.0001), "e");
        hvn[i][j]->SetName(Form("hvn_%d_%d",i,j));

        vn[i][j] = hvn[i][j]->GetMean() / gRes->Eval( (cent[i]+cent[i+1])/2. );
        vnstat[i][j] = hvn[i][j]->GetMeanError() / gRes->Eval( (cent[i]+cent[i+1])/2. );

        gpt[i]->SetPoint( j, (pt[j]+pt[j+1])/2., vn[i][j]);
        gpt[i]->SetPointError( j, (pt[j+1]-pt[j])/2., vnstat[i][j]);
    }
 }
 gpt[0]->Draw("AP*");
}
