#include <iostream>

#include "TFile.h"
#include "TMath.h"
#include "TH1.h"
#include "TH2.h"
#include "TStyle.h"
#include "TCanvas.h"
#include "TPad.h"
#include "TF1.h"
#include "TF2.h"
#include "TStyle.h"
#include "TPad.h"
#include "TLine.h"
#include "TPaveText.h"
#include "TLegend.h"
#include "TVirtualFitter.h"
#include "TGraph.h"
#include "TMinuit.h"
#include "TColor.h"
#include "TString.h"
#include "TH3D.h"
#include "THnSparse.h"

Double_t ptee_bin_2D[] = {0,0.1,0.2,0.22,0.24,0.26,0.28,0.3,0.32,0.34,0.36,0.38,0.4,0.42,0.44,0.46,0.48,0.5,0.52,0.54,0.56,0.58,0.6,0.62,0.64,0.66,0.68,0.7,0.72,0.74,0.76,0.78,0.8,0.82,0.84,0.86,0.88,0.9,0.92,0.94,0.96,0.98,1.,1.2,1.4,1.6,1.8,2.,2.2,2.4,2.6,2.8,3.,3.2,3.4,3.6,3.8,4.,4.5,5.,5.5,6.,6.5,7.,7.5,8.,8.5,9.,10.,15,20};
Int_t nbinsptee_2D  = sizeof(ptee_bin_2D)/sizeof(*ptee_bin_2D) -1;
Double_t mee_bin_2D[]   = {0.0,0.04,0.14,0.24,0.28,0.4,0.44,0.5,0.7,0.8,0.9,1.,1.1,1.4,1.6,1.9,2.0,2.7,2.9,3.0,3.1,3.3,4.0};
Int_t nbinsmee_2D  = sizeof(mee_bin_2D)/sizeof(*mee_bin_2D) -1;

TH2D *Rebin2DHistogram(TH2D *h, Int_t n_bins_mee, Double_t* bins_mee, Int_t n_bins_ptee, Double_t* bins_ptee,TString name);

void PlotDielectronEfficiency(TString namefile="../MC/AnalysisResults.root")
{

  //
  // Comparison
  //

  gStyle->SetPalette(1);
  gStyle->SetOptStat(1111);
  gStyle->SetPadBorderMode(0);
  gStyle->SetCanvasColor(10);
  gStyle->SetPadLeftMargin(0.13);
  gStyle->SetPadRightMargin(0.13);
  gStyle->SetPadBottomMargin(0.13);
  gStyle->SetPadTopMargin(0.13);

  //
  //

  printf("Take file DATA\n");

  TFile *fdata = TFile::Open(namefile.Data());
  TDirectoryFile *dir = (TDirectoryFile *) fdata->Get("dielectron-mc_DCAz");

  // Generated
  TH2D*Gen;
  TDirectoryFile *dirMC_0 = (TDirectoryFile *) dir->Get("Generated");
  TDirectoryFile *dirMC_1 = (TDirectoryFile *) dirMC_0->Get("ccbar");
  TDirectoryFile *dirMC_2 = (TDirectoryFile *) dirMC_1->Get("c2l_c2l");
  TDirectoryFile *dirMC_3 = (TDirectoryFile *) dirMC_2->Get("uls");
  THnSparseD *hs = (THnSparseD *) dirMC_3->Get("hs");
  // axis 0: mee; 1: ptee; 2: yee; 3: deltaphi, 4: deltaeta, 5: costhetapol, 6: phipol, 7: quadnom, 8: acco, 9: asymm_pt, 10: dphiee
  Gen = (TH2D *) (hs->Projection(1,0));
  //Gen =  Rebin2DHistogram(geno, nbinsmee_2D, mee_bin_2D, nbinsptee_2D, ptee_bin_2D,"generated");
  Gen->SetDirectory(0);
  Gen->SetStats(0);
  Gen->SetName("2DGenerated");
  Gen->SetTitle("");



  // Reconstructed
  TH2D*Rec;
  TDirectoryFile *dirRec_0 = (TDirectoryFile *) dir->Get("Pair");
  TDirectoryFile *dirRec_1 = (TDirectoryFile *) dirRec_0->Get("ccbar");
  TDirectoryFile *dirRec_2 = (TDirectoryFile *) dirRec_1->Get("c2l_c2l");
  TDirectoryFile *dirRec_3 = (TDirectoryFile *) dirRec_2->Get("uls");
  THnSparseD *hsrec = (THnSparseD *) dirRec_3->Get("hs");
  // axis 0: mee; 1: ptee; 2: yee; 3: deltaphi, 4: deltaeta, 5: costhetapol, 6: phipol, 7: quadnom, 8: acco, 9: asymm_pt, 10: dphiee, 11: DCAzee
  Rec = (TH2D *) (hsrec->Projection(1,0));
  //Rec =  Rebin2DHistogram(reco, nbinsmee_2D, mee_bin_2D, nbinsptee_2D, ptee_bin_2D,"reconstructed");
  Rec->SetName("2DReconstructed");
  Rec->SetDirectory(0);
  Rec->SetStats(0);
  Rec->GetXaxis()->SetTitle("#it{m}_{ee} (GeV/#it{c}^{2})");
  Rec->GetYaxis()->SetTitle("#it{p}_{T,ee} (GeV/#it{c})");
  Rec->GetZaxis()->SetTitle("Eff");
  Rec->SetTitle("");


  // Efficiency
  Rec->Divide(Rec,Gen,1.,1.,"B");

  //
  // Plot
  //
  TCanvas *c2de = new TCanvas("c2deff","",800,800);
  c2de->cd();
  gPad->SetTicks();
  Rec->GetZaxis()->SetRangeUser(0.,0.5);
  Rec->GetXaxis()->SetRangeUser(0.,4.);
  Rec->GetYaxis()->SetRangeUser(0.,4.);
  Rec->Draw("colz");


}
//_________________________________________________________________
TH2D *Rebin2DHistogram(TH2D *hIn, Int_t n_bins_mee, Double_t* bins_mee, Int_t n_bins_ptee, Double_t* bins_ptee,TString name)
{

  // Init output histo
  TH2D* hOut = new TH2D(name.Data(), hIn->GetTitle(), n_bins_mee, bins_mee, n_bins_ptee, bins_ptee);

  hOut->GetXaxis()->SetTitle(hIn->GetXaxis()->GetTitle());
  hOut->GetYaxis()->SetTitle(hIn->GetYaxis()->GetTitle());
  hOut->GetZaxis()->SetTitle(hIn->GetZaxis()->GetTitle());
  Double_t bin_content_temp = 0;
  Double_t bin_center_mee = -1;
  Double_t bin_center_ptee = -1;

  // loop over bins and filled
  for (Int_t i_mee = 0; i_mee <= hIn->GetNbinsX()+1; ++i_mee){
    for (Int_t j_ptee = 0; j_ptee <= hIn->GetNbinsY()+1; ++j_ptee){
      bin_content_temp = hIn->GetBinContent(i_mee, j_ptee);

      bin_center_mee = hIn->GetXaxis()->GetBinCenter(i_mee);
      bin_center_ptee = hIn->GetYaxis()->GetBinCenter(j_ptee);

      hOut->Fill(bin_center_mee, bin_center_ptee, bin_content_temp);
    }
  }
  // Setting the bin error manually to avoid conflicts between root5 and root6
  for (Int_t i_mee = 0; i_mee <= hOut->GetNbinsX()+1; ++i_mee){
    for (Int_t j_ptee = 0; j_ptee <= hOut->GetNbinsY()+1; ++j_ptee){
      Double_t bin_content = hOut->GetBinContent(i_mee, j_ptee);
      hOut->SetBinError(i_mee, j_ptee, TMath::Sqrt(bin_content));
    }
  }

  return hOut;

}
